$(document).ready(function() {
    let select_country = $('#input-gateway-delivery-country');
    let select_city = $('#input-gateway-delivery-city');
    let select_terminal = $('#input-gateway-delivery-terminal');
    let btn_shipping_method = $('#button-shipping-method');
    let btn_payment_methods = $('button#button-payment-methods');
    let route = 'extension/paysera_delivery/shipping/paysera' + OpenCartRouteActionSeparator;
    let loading = new Option('Loading...', 0, true, true);
    let url = 'index.php';
    let default_index = 'default';

    select_country.select2();
    select_city.select2();
    select_terminal.select2();

    select_country.on('select2:select', function(el) {
        let delivery_gateway_code = getShippingMethod().replace('paysera.', '');
        let country_id = $(this).val();

        if (selected_terminal_data.country !== country_id) {
            selected_terminal_data = {
                country: country_id,
                city: null,
                terminal: null
            };
        }

        if (country_id !== default_index) {
            getConfirmButton().prop('disabled', true);
            clearPaymentMethod();
            select_city.empty();
            select_city.append(loading).trigger('change');
            select_city.val(0).trigger("change");
            select_city.parent().parent().removeClass('hidden');

            select_terminal.empty();
            select_terminal.parent().parent().addClass('hidden');

            $.ajax({
                url,
                data: {
                    route: route + 'cities',
                    delivery_gateway_code,
                    country_id
                }
            })
                .done(function (cities) {
                    let delivery_city = selected_terminal_data.city || select_city.data('city');
                    let default_option = cities.shift();
                    let options = `<option value="${default_index}">${default_option.default}</option>`;
                    let is_default_index = true;

                    if (delivery_city === '') {
                        delivery_city = $('#input-shipping-city').val().toString();
                    }

                    cities.forEach(city => {
                        if (removeDiacritics(delivery_city).toLowerCase() === removeDiacritics(city).toLowerCase()) {
                            delivery_city = city;
                            options += `<option value="${delivery_city}" selected>${delivery_city}</option>`;
                            is_default_index = false;
                            selected_terminal_data.city = delivery_city;
                        } else {
                            options += `<option value="${city}">${city}</option>`;
                        }
                    });

                    select_city.html(options);

                    if (is_default_index) {
                        select_city.val(default_index).trigger('change');
                    } else {
                        select_city.val(delivery_city).trigger('change');

                        if (select_country.val() !== default_index && select_city.val() !== default_index) {
                            select_city.trigger('select2:select');
                        }
                    }
                });
        } else {
            select_city.parent().parent().addClass('hidden');
            select_terminal.parent().parent().addClass('hidden');
        }
    });

    select_city.on('select2:select', function(el) {
        let delivery_gateway_code = getShippingMethod().replace('paysera.', '');
        let country_id = select_country.val();
        let city = $(this).val() || selected_terminal_data.city;

        if (selected_terminal_data.city !== city) {
            selected_terminal_data = {
                country: country_id,
                city: city,
                terminal: null
            };
            getConfirmButton().prop('disabled', true);
            clearPaymentMethod();
        }

        if (country_id !== default_index && city !== default_index) {
            select_terminal.empty();
            select_terminal.append(loading).trigger('change');
            select_terminal.parent().parent().removeClass('hidden');

            $.ajax({
                url,
                data: {
                    route: route + 'terminals',
                    delivery_gateway_code,
                    country_id,
                    city
                }
            })
                .done(function (terminals) {
                    let options;

                    for (const [location_id, location_name] of Object.entries(terminals)) {
                        options += `<option value="${location_id}">${location_name}</option>`;
                    }

                    select_terminal.html(options);
                    select_terminal.val(selected_terminal_data.terminal || 'default').trigger('select2:select');
                });
        } else {
            select_terminal.parent().parent().addClass('hidden');
            getConfirmButton().prop('disabled', true);
            clearPaymentMethod();
        }
    })

    select_terminal.on('select2:select', function(el) {
        let country_id = select_country.val();
        let city = select_city.val();
        let terminal = $(this).val() || selected_terminal_data.terminal;
        let is_disabled = (
            country_id !== default_index
            && city !== default_index
            && terminal !== default_index
        )

        if (selected_terminal_data.terminal !== terminal) {
            selected_terminal_data = {
                country: country_id,
                city: city,
                terminal: terminal
            };
        }

        if (terminal !== default_index) {
            selected_terminal_data.terminal = terminal;
            getConfirmButton().prop('disabled', ($('#input-payment-method').val() === ''));
            getPaymentMethodSelect().prop('disabled', false);
            $.ajax({
                url: `${url}?route=${route}saveDeliveryGateway`,
                method: 'POST',
                data: {
                    country_id,
                    city,
                    terminal,
                }
            })
                .done(function () {
                    btn_shipping_method.prop('disabled', !is_disabled);
                    btn_payment_methods.prop('disabled', !is_disabled);
                });
        } else {
            getConfirmButton().prop('disabled', true);
            clearPaymentMethod();
        }
    });

    function removeDiacritics(str) {
        return str.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }

    if (getShippingMethod().startsWith('paysera.') && select_country.val() !== default_index) {
        select_country.trigger('select2:select');
    }

    function getShippingMethod() {
        return $('input[name=shipping_method]:checked').val()
            || $('#input-shipping-code').val()
            || $('select#input-shipping-method').val()
            || '';
    }

    function getConfirmButton() {
        // this method is necessary because of the OC removes the button from the DOM and creates new one at some moment
        return $('button#button-confirm');
    }

    function getPaymentMethodSelect() {
        // and this one
        return $('select#input-payment-method');
    }

    function clearPaymentMethod() {
        getPaymentMethodSelect().val('').prop('disabled', true);
    }
});
