<?php

namespace Paysera\Payment\Service;

use Opencart\System\Library\Session;
use Paysera\Payment\Entity\SessionData;
use Paysera\Payment\Normalizer\SessionNormalizer;

class SessionManager
{
    /** @var Session  */
    private $session;

    private SessionNormalizer $sessionNormalizer;

    public function __construct($session, SessionNormalizer $sessionNormalizer)
    {
        $this->session = $session;
        $this->sessionNormalizer = $sessionNormalizer;
    }

    public function getSessionData(): SessionData
    {
        return $this->sessionNormalizer->denormalize($this->session->data);
    }

    public function clearSessionParameter(string $parameter): void
    {
        if (isset($this->session->data[$parameter])) {
            $this->session->data[$parameter] = null;
        }
    }

    public function clearCheckoutSessionParameters(): void
    {
        $checkoutSessionParameters = [
            'order_id',
            'payment_address',
            'payment_method',
            'payment_methods',
            'shipping_address',
            'shipping_method',
            'shipping_methods',
            'comment',
            'coupon',
            'reward',
            'voucher',
            'vouchers',
        ];

        foreach ($checkoutSessionParameters as $checkoutSessionParameter) {
            $this->clearSessionParameter($checkoutSessionParameter);
        }
    }
}
