<?php

namespace Paysera\Payment\Service;

use Paysera\CheckoutSdk\CheckoutFacade;
use Paysera\CheckoutSdk\Entity\Collection\PaymentMethodCountryCollection;
use Paysera\CheckoutSdk\Entity\Request\PaymentMethodsRequest;
use Paysera\Payment\Entity\Order;
use Paysera\Payment\Entity\PluginSettings;
use Paysera\Payment\PayseraPaymentSettings;

class PaymentMethodsReceiver
{
    public function __construct(private PluginSettings $pluginSettings, private CheckoutFacade $checkoutFacade)
    {}

    public function getPaymentMethodCountries(Order $order): PaymentMethodCountryCollection
    {
        $request = new PaymentMethodsRequest(
            $this->pluginSettings->getProjectId() ?? PayseraPaymentSettings::DEFAULT_PROJECT_ID,
            $order->getAmount(),
            $order->getCurrency()
        );

        return $this->checkoutFacade->getPaymentMethods($request);
    }
}
