<?php

namespace Paysera\Payment\Service\Helper;

use Opencart\System\Library\Language;

class BuyerConsentHelper
{
    private const BUYER_CONSENT_TEXT = 'buyer_consent_text';
    private const BUYER_CONSENT_LINK = 'buyer_consent_link';
    private const BUYER_CONSENT_RULES = 'buyer_consent_rules';

    private const BUYER_CONSENT_TRANSLATION_KEYS = [
        self::BUYER_CONSENT_TEXT,
        self::BUYER_CONSENT_LINK,
        self::BUYER_CONSENT_RULES,
    ];

    /**
     * @var Language
     */
    private $language;

    public function __construct($language)
    {
        $this->language = $language;
    }

    public function getBuyerConsent(): string
    {
        $translations = $this->getTranslations();

        return sprintf(
            $translations[self::BUYER_CONSENT_TEXT],
            sprintf(
                '<a href="%s">%s</a>',
                $translations[self::BUYER_CONSENT_LINK],
                $translations[self::BUYER_CONSENT_RULES]
            )
        );
    }

    /**
     * @return array<string, string>
     */
    private function getTranslations(): array
    {
        $translations = [];
        foreach (self::BUYER_CONSENT_TRANSLATION_KEYS as $key) {
            $translations[$key] = $this->language->get($key);
        }

        return $translations;
    }
}
