<?php

namespace Paysera\Payment\Service\Helper;

use Opencart\System\Library\Cart\Currency;

class AmountHelper
{
    /**
     * @var Currency
     */
    private $currency;

    public function __construct($currency)
    {
        $this->currency = $currency;
    }

    public function getAmountInCents(float $total, string $currency): int
    {
        return (int) round($total * $this->currency->getValue($currency) * 100);
    }
}
