<?php

namespace Paysera\Payment\Normalizer;

use Paysera\Payment\Entity\OrderShippingMethod;
use Paysera\Payment\Entity\SessionData;

class SessionNormalizer
{
    public function denormalize(array $sessionDataAsArray): SessionData
    {
        $sessionData = new SessionData();

        if (isset($sessionDataAsArray['order_id'])) {
            $sessionData->setOrderId((int) $sessionDataAsArray['order_id']);
        }
        if (isset($sessionDataAsArray['currency'])) {
            $sessionData->setCurrency($sessionDataAsArray['currency']);
        }
        if (isset($sessionDataAsArray['user_token'])) {
            $sessionData->setUserToken($sessionDataAsArray['user_token']);
        }
        if (isset($sessionDataAsArray['shipping_method'])) {
            $shippingMethod = $sessionDataAsArray['shipping_method'];

            $sessionData->setShippingMethod(
                new OrderShippingMethod(
                    (string)($shippingMethod['name'] ?? ''),
                    (string)($shippingMethod['code'] ?? ''),
                    (float)($shippingMethod['cost'] ?? 0),
                    (string)json_encode($shippingMethod)
                )
            );
        }

        return $sessionData;
    }
}
