<?php

declare(strict_types=1);

namespace Paysera\Payment\Entity;

class OrderShippingMethod
{
    private string $title;
    private string $code;
    private float $cost;
    private string $data;

    public function __construct(
        string $title,
        string $code,
        float $cost,
        string $data
    ) {
        $this->title = $title;
        $this->code = $code;
        $this->cost = $cost;
        $this->data = $data;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getCost(): float
    {
        return $this->cost;
    }

    public function getData(): string
    {
        return $this->data;
    }
}
