<?php

declare(strict_types=1);

namespace Opencart\Admin\Model\Extension\OcPaysera\Payment;

use Opencart\System\Engine\Model;

class Paysera extends Model
{
    public function getSettingValue(string $code, string $key, int $storeId = 0): ?string
    {
        $query = $this->db->query(
            "SELECT `value` FROM " . DB_PREFIX . "setting"
            . " WHERE `store_id` = " . $storeId
            . " AND `key` = '" . $this->db->escape($key) . "'"
            . " LIMIT 1"
        );

        if ($query->num_rows) {
            return $query->row['value'];
        }

        return null;
    }

    public function addSettingValue(string $code, string $key, string $value = '', int $storeId = 0): void
    {
        $this->db->query(
            "INSERT INTO " . DB_PREFIX . "setting"
            . " SET `store_id` = '" . $storeId . "',"
            . " `code` = '" . $this->db->escape($code) . "',"
            . " `key` = '" . $this->db->escape($key) . "',"
            . " `value` = '" . $this->db->escape($value) . "'"
        );
    }
}
