<?php

declare(strict_types=1);

namespace Paysera\Payment\Service;

use Paysera\Payment\PayseraPaymentSettings;

class RoutePathResolver
{
    private string $opencartVersion;

    public function __construct(string $opencartVersion)
    {
        $this->opencartVersion = $opencartVersion;
    }

    /**
     * Resolving incompatible route separator changes in different CMS versions
     * @param string $routeAction
     * @return string
     * @link https://github.com/opencart/opencart/releases/tag/4.0.2.0
     */
    public function getCompatibleRoutePath(string $routeAction): string
    {
        return PayseraPaymentSettings::EXTENSION . $this->getRouteActionSeparator() . $routeAction;
    }

    /**
     * Get compatible route separator for different CMS versions
     * @return string
     * @link https://github.com/opencart/opencart/releases/tag/4.0.2.0
     */
    public function getRouteActionSeparator(): string
    {
        return version_compare($this->opencartVersion, '4.0.2.0', '<')
            ? '|'
            : '.';
    }
}
