<?php

namespace Paysera\Payment\Service;

use Paysera\CheckoutSdk\Entity\PaymentMethod;
use Paysera\CheckoutSdk\Entity\PaymentMethodCountry;
use Paysera\CheckoutSdk\Entity\PaymentMethodGroup;
use Paysera\CheckoutSdk\Service\Translator;

class PaymentMethodTranslator
{
    private Translator $translator;

    public function __construct(private LanguageCodeReceiver $languageReceiver)
    {
        $this->translator = new Translator();
    }

    public function getTitle(PaymentMethodCountry|PaymentMethodGroup|PaymentMethod $entity): string
    {
        return $this->translator->getTitle($entity, $this->languageReceiver->getLanguageCode());
    }

    public function getLogo(PaymentMethod $entity): ?string
    {
        return $this->translator->getLogo($entity, $this->languageReceiver->getLanguageCode());
    }
}
