<?php

namespace Paysera\Payment\Normalizer;

use Paysera\Payment\Entity\PluginSettings;

class PluginSettingsNormalizer
{
    public function denormalize(array $settings): PluginSettings
    {
        $pluginSettings = new PluginSettings();

        if (isset($settings['payment_paysera_project']) && $settings['payment_paysera_project'] !== '') {
            $pluginSettings->setProjectId((int) $settings['payment_paysera_project']);
        }
        if (isset($settings['payment_paysera_sign']) && $settings['payment_paysera_sign'] !== '') {
            $pluginSettings->setProjectPassword((string) $settings['payment_paysera_sign']);
        }
        if (isset($settings['payment_paysera_category']) && is_array($settings['payment_paysera_category'])) {
            $pluginSettings->setSelectedCountries($settings['payment_paysera_category']);
        }
        if (isset($settings['payment_paysera_buyer_consent'])) {
            $pluginSettings->setIsBuyerConsent((bool) $settings['payment_paysera_buyer_consent']);
        }
        if (isset($settings['payment_paysera_display_payments_list'])) {
            $pluginSettings->setIsDisplayPaymentMethods((bool) $settings['payment_paysera_display_payments_list']);
        }
        if (isset($settings['payment_paysera_grid_view'])) {
            $pluginSettings->setIsGridView((bool) $settings['payment_paysera_grid_view']);
        }
        if (isset($settings['payment_paysera_description'])) {
            $pluginSettings->setDescription((string) $settings['payment_paysera_description']);
        }
        if (isset($settings['payment_paysera_test'])) {
            $pluginSettings->setIsTest((bool) $settings['payment_paysera_test']);
        }
        if (isset($settings['payment_paysera_pending_status_id'])) {
            $pluginSettings->setPendingStatus((int) $settings['payment_paysera_pending_status_id']);
        }
        if (isset($settings['payment_paysera_new_order_status_id'])) {
            $pluginSettings->setNewOrderStatus((int) $settings['payment_paysera_new_order_status_id']);
        }
        if (isset($settings['payment_paysera_paid_status_id'])) {
            $pluginSettings->setPaidStatus((int) $settings['payment_paysera_paid_status_id']);
        }
        if (isset($settings['payment_paysera_owner_code'])) {
            $pluginSettings->setOwnerCode((string) $settings['payment_paysera_owner_code']);
        }
        if (isset($settings['payment_paysera_owner'])) {
            $pluginSettings->setIsOwner((bool) $settings['payment_paysera_owner']);
        }
        if (isset($settings['payment_paysera_quality'])) {
            $pluginSettings->setIsQuality((bool) $settings['payment_paysera_quality']);
        }

        return $pluginSettings;
    }
}
