<?php

/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please email
 * to support@paysera.com, so we can send you a copy immediately.
 *
 * @author    Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Opencart\Catalog\Model\Extension\OcPaysera\Payment;

use Opencart\System\Engine\Model;

class Paysera extends Model
{
    public const CONFIG_PAYSERA_ENABLE = 'payment_paysera_status';
    public const CONFIG_PAYSERA_TITLE = 'payment_paysera_title';
    public const CONFIG_PAYSERA_GEO = 'payment_paysera_geo_zone_id';
    public const PAYMENT_PAYSERA_SORT_ORDER = 'payment_paysera_sort_order';
    public const PAYMENT_PAYSERA_TOTAL = 'payment_paysera_total';
    public const LANGUAGE_TEXT_TITLE = 'text_title';
    public const LANGUAGE_HEADING_TITLE = 'heading_title';

    public function getMethod(array $address): array
    {
        if (!$this->getStatus($address)) {
            return [];
        }

        $this->load->language('extension/oc_paysera/payment/paysera');

        return [
            'code' => 'paysera',
            'title' => $this->getTextTitle($this->language),
            'sort_order' => $this->config->get(self::PAYMENT_PAYSERA_SORT_ORDER),
        ];
    }

    public function getMethods(array $address): array
    {
        if (!$this->getStatus($address)) {
            return [];
        }

        $this->load->language('extension/oc_paysera/payment/paysera');

        return [
            'code' => 'paysera',
            'name' => $this->language->get(self::LANGUAGE_HEADING_TITLE),
            'sort_order' => $this->config->get(self::PAYMENT_PAYSERA_SORT_ORDER),
            'option' => [
                'payment' => [
                    'code' => 'paysera.payment',
                    'name' => $this->getTextTitle($this->language),
                ]
            ],
        ];
    }

    private function getTextTitle($language): string
    {
        $textTitle = $this->config->get(self::CONFIG_PAYSERA_TITLE);

        if (empty($textTitle)) {
            $textTitle = $language->get(self::LANGUAGE_TEXT_TITLE);
        }

        return $textTitle;
    }

    private function getStatus(array $address): bool
    {
        $status = false;

        $this->load->model('checkout/order');

        $total = $this->getTotal();
        if (
            $this->config->get(self::CONFIG_PAYSERA_ENABLE)
            && ($total >= 0 && (float) $this->config->get($this::PAYMENT_PAYSERA_TOTAL) <= $total)
        ) {
            $geoZoneId = (int)$this->config->get(self::CONFIG_PAYSERA_GEO);
            $zoneId = 0;
            $countryId = 0;

            if (isset($address['country_id']) && isset($address['zone_id'])) {
                $zoneId = (int)$address['zone_id'];
                $countryId = (int)$address['country_id'];
            } elseif (isset($this->session->data['payment_address'])) {
                $zoneId = (int)$this->session->data['payment_address']['zone_id'];
                $countryId = (int)$this->session->data['payment_address']['country_id'];
            } elseif (isset($this->session->data['shipping_address'])) {
                $zoneId = (int)$this->session->data['shipping_address']['zone_id'];
                $countryId = (int)$this->session->data['shipping_address']['country_id'];
            }

            $zones = implode(',', [$zoneId, 0]);
            $query = $this->db->query(
                "SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone"
                . " WHERE geo_zone_id = '" . $geoZoneId
                . "' AND country_id = '" . $countryId
                . "' AND zone_id IN (" . $zones . ")"
            );

            if (!$this->config->get(self::CONFIG_PAYSERA_GEO) || $query->num_rows) {
                $status = true;
            }
        }

        return $status;
    }

    private function getTotal(): float
    {
        if (isset($this->session->data['order_id'])) {
            $order = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            if ($order) {
                return (float)$order['total'];
            }
        }

        $totals = [];
        $taxes = $this->cart->getTaxes();
        $total = 0.;

        $this->load->model('checkout/cart');
        ($this->model_checkout_cart->getTotals)($totals, $taxes, $total);

        return $total;
    }
}
