<?php

namespace Paysera\Payment\Service;

use Opencart\System\Library\Language;

class LanguageCodeReceiver
{
    public const DEFAULT_CODE = 'en';
    public const DEFAULT_PAYSERA_CODE = 'ENG';
    private const AVAILABLE_LANGUAGES = [
        'lt' => 'lt',
        'lv' => 'lv',
        'ru' => 'ru',
        'en' => 'en',
        'pl' => 'pl',
        'bg' => 'bg',
        'ee' => 'ee',
    ];
    private const PAYSERA_AVAILABLE_LANGUAGES = [
        'lt' => 'LIT',
        'lv' => 'LAV',
        'ru' => 'RUS',
        'en' => 'ENG',
        'pl' => 'POL',
        'bg' => 'BGR',
        'ee' => 'EST',
    ];

    /**
     * @var Language
     */
    private $language;

    public function __construct($language)
    {
        $this->language = $language;
    }

    public function getLanguageCode(): string
    {
        $language = strtolower($this->language->get('code'));

        return self::AVAILABLE_LANGUAGES[$language] ?? self::DEFAULT_CODE;
    }

   public function getPayseraLanguageCode(): string
    {
        $languageCode = $this->getLanguageCode();

        return self::PAYSERA_AVAILABLE_LANGUAGES[$languageCode] ?? self::DEFAULT_PAYSERA_CODE;
    }
}
