<?php

namespace Paysera\Payment\Entity;

class PluginSettings
{
    private ?int $projectId = null;
    private ?string $projectPassword = null;
    private array $selectedCountries = [];
    private bool $isBuyerConsent = false;
    private bool $isDisplayPaymentMethods = false;
    private bool $isGridView = false;
    private string $description = '';
    private bool $isTest = false;
    private int $pendingStatus = 0;
    private int $newOrderStatus = 0;
    private int $paidStatus = 0;
    private ?string $ownerCode = null;
    private bool $isOwner = false;
    private bool $isQuality = false;

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $projectId): self
    {
        $this->projectId = $projectId;

        return $this;
    }

    public function getProjectPassword(): ?string
    {
        return $this->projectPassword;
    }

    public function setProjectPassword(?string $projectPassword): self
    {
        $this->projectPassword = $projectPassword;

        return $this;
    }

    public function getSelectedCountries(): array
    {
        return $this->selectedCountries;
    }

    public function setSelectedCountries(array $selectedCountries): self
    {
        $this->selectedCountries = $selectedCountries;

        return $this;
    }

    public function isBuyerConsent(): bool
    {
        return $this->isBuyerConsent;
    }

    public function setIsBuyerConsent(bool $isBuyerConsent): self
    {
        $this->isBuyerConsent = $isBuyerConsent;

        return $this;
    }

    public function isDisplayPaymentMethods(): bool
    {
        return $this->isDisplayPaymentMethods;
    }

    public function setIsDisplayPaymentMethods(bool $isDisplayPaymentMethods): self
    {
        $this->isDisplayPaymentMethods = $isDisplayPaymentMethods;

        return $this;
    }

    public function isGridView(): bool
    {
        return $this->isGridView;
    }

    public function setIsGridView(bool $isGridView): self
    {
        $this->isGridView = $isGridView;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function isTest(): bool
    {
        return $this->isTest;
    }

    public function setIsTest(bool $isTest): self
    {
        $this->isTest = $isTest;

        return $this;
    }

    public function getPendingStatus(): int
    {
        return $this->pendingStatus;
    }

    public function setPendingStatus(int $pendingStatus): self
    {
        $this->pendingStatus = $pendingStatus;

        return $this;
    }

    public function getNewOrderStatus(): int
    {
        return $this->newOrderStatus;
    }

    public function setNewOrderStatus(int $newOrderStatus): self
    {
        $this->newOrderStatus = $newOrderStatus;

        return $this;
    }

    public function getPaidStatus(): int
    {
        return $this->paidStatus;
    }

    public function setPaidStatus(int $paidStatus): self
    {
        $this->paidStatus = $paidStatus;

        return $this;
    }

    public function getOwnerCode(): ?string
    {
        return $this->ownerCode;
    }

    public function setOwnerCode(?string $ownerCode): self
    {
        $this->ownerCode = $ownerCode;

        return $this;
    }

    public function isOwner(): bool
    {
        return $this->isOwner;
    }

    public function setIsOwner(bool $isOwner): self
    {
        $this->isOwner = $isOwner;

        return $this;
    }

    public function isQuality(): bool
    {
        return $this->isQuality;
    }

    public function setIsQuality(bool $isQuality): self
    {
        $this->isQuality = $isQuality;

        return $this;
    }
}
