<?php

namespace Paysera\Payment\Service;

use Opencart\System\Engine\Registry;
use Paysera\Payment\Entity\PluginSettings;
use Paysera\Payment\Normalizer\PluginSettingsNormalizer;

class PluginSettingsManager
{
    public const PLUGIN_SETTINGS_KEY = 'payment_paysera';

    private array $pluginKeys = [
        'payment_paysera_status',
        'payment_paysera_project',
        'payment_paysera_sign',
        'payment_paysera_test',
        'payment_paysera_total',
        'payment_paysera_title',
        'payment_paysera_description',
        'payment_paysera_display_payments_list',
        'payment_paysera_category',
        'paysera_selected_countries',
        'paysera_countries',
        'payment_paysera_grid_view',
        'payment_paysera_buyer_consent',
        'payment_paysera_default_country',
        'payment_paysera_geo_zone_id',
        'payment_paysera_sort_order',
        'payment_paysera_new_order_status_id',
        'payment_paysera_paid_status_id',
        'payment_paysera_pending_status_id',
        'payment_paysera_quality',
        'payment_paysera_owner',
        'payment_paysera_owner_code',
    ];

    private PluginSettings $paymentSettings;

    /**
     * @param Registry $registry
     * @param PluginSettingsNormalizer $paymentSettingsNormalizer
     */
    public function __construct(private $registry, private PluginSettingsNormalizer $paymentSettingsNormalizer)
    {}

    public function load(): self
    {
        $settings = [];
        foreach ($this->pluginKeys as $key) {
            if (array_key_exists($key, $settings)) {
                continue;
            }
            $settings[$key] = $this->registry->config->get($key);
        }

        $this->paymentSettings = $this->paymentSettingsNormalizer->denormalize($settings);

        return $this;
    }

    public function getSettings(): PluginSettings
    {
        return $this->paymentSettings;
    }

    public function getKeys(): array
    {
        return $this->pluginKeys;
    }
}
