<?php

namespace Paysera\Payment\Service;

use Paysera\CheckoutSdk\CheckoutFacade;
use Paysera\CheckoutSdk\Entity\Collection\PaymentMethodCountryCollection;
use Paysera\Payment\Entity\Order;
use Paysera\Payment\Entity\PluginSettings;

class PaymentMethodManager
{
    private PaymentMethodsReceiver $paymentMethodsReceiver;
    private PaymentMethodCountryCollectionFilter $collectionFilter;
    private PaymentMethodCountryCollection $collection;
    private ?string $buyerCountryCode = null;
    private ?Order $order = null;

    public function __construct(
        private PluginSettings $pluginSettings,
        CheckoutFacade $checkoutFacade
    ) {
        $this->collection = new PaymentMethodCountryCollection();
        $this->paymentMethodsReceiver = new PaymentMethodsReceiver($this->pluginSettings, $checkoutFacade);
        $this->collectionFilter = new PaymentMethodCountryCollectionFilter($this->pluginSettings);
    }

    public function load(Order $order): self
    {
        $this->order = $order;

        if ($this->pluginSettings->isDisplayPaymentMethods()) {
            $this->collection = $this->paymentMethodsReceiver->getPaymentMethodCountries($this->order);
            $this->collection = $this->collectionFilter->filterBySelectedCountries($this->collection);
        }

        $this->buyerCountryCode = null;
        $buyerCountryCode = $this->order->getPayerCountryCode() ?? $this->order->getShippingCountryCode() ?? '';
        $buyerCountryCode = strtolower($buyerCountryCode);

        foreach ($this->collection as $paymentMethodCountry) {
            if ($paymentMethodCountry->getCode() === $buyerCountryCode) {
                $this->buyerCountryCode = $buyerCountryCode;
                break;
            }
            if ($paymentMethodCountry->getCode() === 'other') {
                $this->buyerCountryCode = 'other';
            }
            if ($this->buyerCountryCode === null) {
                $this->buyerCountryCode = $paymentMethodCountry->getCode();
            }
        }

        return $this;
    }

    public function getCollection(): PaymentMethodCountryCollection
    {
        return $this->collection;
    }

    public function getBuyerCountryCode(): ?string
    {
        return $this->buyerCountryCode;
    }

    public function isDisplayCountriesSelect(): bool
    {
        return count($this->collection) > 1;
    }
}
