<?php

namespace Paysera\Payment\Service;

use Paysera\CheckoutSdk\Entity\Collection\PaymentMethodCountryCollection as Collection;
use Paysera\CheckoutSdk\Entity\PaymentMethodCountry;
use Paysera\Payment\Entity\PluginSettings;

class PaymentMethodCountryCollectionFilter
{
    private array $selectedCountries;

    public function __construct(private PluginSettings $pluginSettings)
    {
        $this->selectedCountries = array_map('strtolower', $this->pluginSettings->getSelectedCountries());;
    }

    public function filterBySelectedCountries(Collection $collection): Collection
    {
        if (empty($this->selectedCountries)) {
            return $collection;
        }

        $filteredCollection = $this->filterByCountries($collection, $this->selectedCountries);

        if ($filteredCollection->count() === 0) {
            return $this->filterFallbackPaymentMethods($collection);
        }

        return $filteredCollection;
    }

    private function filterFallbackPaymentMethods(Collection $collection): Collection
    {
        $otherCountry = 'other';

        if (in_array($otherCountry, $this->selectedCountries, true)) {
            return new Collection();
        }

        return $this->filterByCountries($collection, [$otherCountry]);
    }

    private function filterByCountries(Collection $collection, array $countriesInLowercase): Collection
    {
        return $collection->filter(
            static fn(PaymentMethodCountry $country) => in_array(
                strtolower($country->getCode()),
                $countriesInLowercase,
                true
            )
        );
    }
}
