<?php

declare(strict_types=1);

namespace Paysera\Payment\Helper;

use Evp\Component\Money\Money;
use Paysera\CheckoutSdk\Entity\Order;
use Paysera\CheckoutSdk\Entity\PaymentCallbackValidationResponse;
use Paysera\CheckoutSdk\Service\PaymentStatus;
use Paysera\Payment\Service\Logger;

class PaymentHelper
{
    private Logger $logger;

    public function __construct(Logger $logger)
    {
        $this->logger = $logger;
    }

    public function isMerchantOrderPaid(
        PaymentCallbackValidationResponse $callbackResponse,
        Order                             $merchantOrder
    ): bool {
        if ($callbackResponse->getStatus() !== PaymentStatus::SUCCESS) {
            return false;
        }

        try {
            $merchantCurrency = $merchantOrder->getCurrency();
            $merchantAmount = Money::createFromMinorUnits($merchantOrder->getAmount(), $merchantCurrency);
            $callbackCurrency = $callbackResponse->getOrder()->getCurrency();
            $callbackAmount = Money::createFromMinorUnits($callbackResponse->getOrder()->getAmount(), $callbackCurrency);
            $callbackPaymentCurrency = $callbackResponse->getPaymentCurrency();
            $callbackPaymentAmount = Money::createFromMinorUnits(
                $callbackResponse->getPaymentAmount(),
                $callbackPaymentCurrency
            );
        } catch (\Exception $exception) {
            $this->logger->log('Can not compare amounts due to error: ' . $exception->getMessage());

            return false;
        }

        return ($merchantAmount->isEqual($callbackAmount) && $callbackCurrency === $merchantCurrency)
            || ($merchantAmount->isEqual($callbackPaymentAmount) && $callbackPaymentCurrency === $merchantCurrency);
    }
}
