<?php
declare(strict_types=1);

namespace Paysera\Delivery\Update\Updates;

use Paysera\Delivery\Update\MigrationInterface;
use Paysera\Delivery\DatabaseTable;
use ControllerExtensionShippingPaysera as Paysera;

class Update_1_1_3 extends AbstractUpdate implements MigrationInterface
{
    private const DELIVERY_ORDER_ID_COLUMN = 'delivery_order_id';

    protected $db;
    protected $modelSettingEvent;
    private $modelSetting;

    public function __construct($db, $modelSetting, $modelSettingEvent)
    {
        $this->db = $db;
        $this->modelSettingEvent = $modelSettingEvent;
        $this->modelSetting = $modelSetting;
    }

    public function apply()
    {
        if ($this->isColumnExists(DatabaseTable::SHIPPING_REQUEST, self::DELIVERY_ORDER_ID_COLUMN) === false) {
            $this->db->query(
                'ALTER TABLE `' . DatabaseTable::SHIPPING_REQUEST . '` ADD `'. self::DELIVERY_ORDER_ID_COLUMN . '` VARCHAR(255) NULL AFTER `order_id`'
            );
        }

        if ($this->isEventExists(Paysera::PAYSERA_PAYMENT_CONFIRMED_NAME) === false) {
            $this->modelSettingEvent->addEvent(
                Paysera::PAYSERA_PAYMENT_CONFIRMED_NAME,
                Paysera::PAYSERA_PAYMENT_CONFIRMED,
                Paysera::PAYSERA_PAYMENT_CONFIRMED_CONTROLLER
            );
        }

        $this->modelSetting->editSetting('paysera_delivery', ['paysera_delivery_version' => '1.1.3']);
    }

    public function getVersion(): string
    {
        return '1.1.3';
    }
}
