<?php

declare(strict_types=1);

namespace Paysera\Delivery\Normalizer;

use Paysera\Delivery\Entity\ShipmentRequest;
use Paysera\Delivery\Entity\ShipmentRequestGateway;

class ShipmentRequestNormalizer
{
    public function mapToEntity(array $data): ShipmentRequest
    {
        $shipmentRequest = new ShipmentRequest(
            $data['order_id'],
            $data['delivery_order_id'],
            $data['shipping_method'],
            $data['status']
        );

        $terminal = $data['gateway_terminal'] ?? null;
        $isoCode2 = $data['gateway_iso_code_2'] ?? null;
        $city = $data['gateway_city'] ?? null;
        $zoneCode = $data['gateway_zone_code'] ?? null;

        if (is_string($terminal) || is_string($isoCode2) || is_string($city) || is_string($zoneCode)) {
            $shipmentRequest->setShippingRequestGateway(
                new ShipmentRequestGateway(
                    $terminal,
                    $isoCode2,
                    $city,
                    $zoneCode
                )
            );
        }

        return $shipmentRequest;
    }
}
