<?php

namespace Paysera\Delivery\Normalizer;

use Paysera\Delivery\Entity\DeliveryGatewaySettings;
use Paysera\Delivery\PayseraDeliverySettings;

class DeliveryGatewaySettingsNormalizer
{
    private $shipmentGatewayNormalizer;

    public function __construct()
    {
        $this->shipmentGatewayNormalizer = new ShipmentGatewayNormalizer();
    }

    /**
     * @param array $settings
     * @return DeliveryGatewaySettings
     */
    public function mapToEntity($settings)
    {
        $deliveryGatewaySetting = (new DeliveryGatewaySettings())
            ->setTitle($settings[PayseraDeliverySettings::TITLE] ?? '')
            ->setDescription($settings[PayseraDeliverySettings::DESCRIPTION] ?? '')
            ->setMaximumWeight(
                $settings[PayseraDeliverySettings::MAXIMUM_WEIGHT] ?? PayseraDeliverySettings::DEFAULT_MAXIMUM_WEIGHT
            )
            ->setMinimumWeight(
                $settings[PayseraDeliverySettings::MINIMUM_WEIGHT] ?? PayseraDeliverySettings::DEFAULT_MINIMUM_WEIGHT
            )
            ->setFee($settings[PayseraDeliverySettings::FEE] ?? PayseraDeliverySettings::DEFAULT_FEE)
            ->setFreeDeliveryThreshold(
                $settings[PayseraDeliverySettings::FREE_DELIVERY_THRESHOLD]
                ?? PayseraDeliverySettings::DEFAULT_FREE_DELIVERY_THRESHOLD
            )
            ->setReceiverType($settings[PayseraDeliverySettings::RECEIVER_TYPE])
            ->setSenderType(
                $settings[PayseraDeliverySettings::SENDER_TYPE] ?? PayseraDeliverySettings::DEFAULT_SENDER_TYPE
            )
            ->setSortOrder(
                isset($settings[PayseraDeliverySettings::SORT_ORDER]) && !empty($settings[PayseraDeliverySettings::SORT_ORDER])
                    ? $settings[PayseraDeliverySettings::SORT_ORDER]
                    : null
            )
            ->setGeoZone(
                isset($settings[PayseraDeliverySettings::GEO_ZONE]) && !empty($settings[PayseraDeliverySettings::GEO_ZONE])
                    ? $settings[PayseraDeliverySettings::GEO_ZONE]
                    : null
            )
        ;

        if (isset($settings[PayseraDeliverySettings::SENDER_TYPE])) {
            $deliveryGatewaySetting->setSenderType($settings[PayseraDeliverySettings::SENDER_TYPE]);
        }

        if (isset($settings[PayseraDeliverySettings::SHIPMENT_GATEWAY])) {
            $deliveryGatewaySetting->setShipmentGateway(
                $this->shipmentGatewayNormalizer->mapToEntity($settings[PayseraDeliverySettings::SHIPMENT_GATEWAY])
            );
        }

        return $deliveryGatewaySetting;
    }

    /**
     * @param DeliveryGatewaySettings $deliverySettings
     * @return array
     */
    public function mapFromEntity($deliverySettings)
    {
        return [
            PayseraDeliverySettings::TITLE => $deliverySettings->getTitle(),
            PayseraDeliverySettings::DESCRIPTION => $deliverySettings->getDescription(),
            PayseraDeliverySettings::MAXIMUM_WEIGHT => $deliverySettings->getMaximumWeight(),
            PayseraDeliverySettings::MINIMUM_WEIGHT => $deliverySettings->getMinimumWeight(),
            PayseraDeliverySettings::FEE => $deliverySettings->getFee(),
            PayseraDeliverySettings::FREE_DELIVERY_THRESHOLD => $deliverySettings->getFreeDeliveryThreshold(),
            PayseraDeliverySettings::RECEIVER_TYPE => $deliverySettings->getReceiverType(),
            PayseraDeliverySettings::SENDER_TYPE => $deliverySettings->getSenderType(),
            PayseraDeliverySettings::SORT_ORDER => $deliverySettings->getSortOrder(),
            PayseraDeliverySettings::GEO_ZONE => $deliverySettings->getGeoZone(),
            PayseraDeliverySettings::SHIPMENT_GATEWAY => $this->shipmentGatewayNormalizer->mapFromEntity(
                $deliverySettings->getShipmentGateway()
            ),
        ];
    }
}
