<?php

declare(strict_types=1);

namespace Paysera\Delivery\Model;

use Paysera\Delivery\Entity\Product;
use Paysera\Delivery\Normalizer\ProductNormalizer;

class ProductModel
{
    /**
     * ModelCatalogProduct - catalog/model/catalog/product.php
     */
    private $productModel;

    /**
     * @var ProductNormalizer
     */
    private $productNormalizer;

    public function __construct($productModel, ProductNormalizer $productNormalizer)
    {
        $this->productModel = $productModel;
        $this->productNormalizer = $productNormalizer;
    }

    public function getProduct(string $productId): ?Product
    {
        $product = $this->productModel->getProduct($productId);
        if (count($product) === 0) {
            return null;
        }

        return $this->productNormalizer->mapToEntity($product);
    }
}
