<?php

namespace Paysera\Delivery\Service;

class DeliveryOrderHistoryGenerator
{
    private $language;
    private $modelCheckoutOrder;

    public function __construct($language, $modelCheckoutOrder)
    {
        $this->language = $language;
        $this->modelCheckoutOrder = $modelCheckoutOrder;
    }

    public function generateDefaultOrderHistory(string $orderId, string $deliveryOrderNumber, int $orderStatus): void
    {
        $this->modelCheckoutOrder->addOrderHistory(
            $orderId,
            $orderStatus,
            sprintf($this->language->get('order_created_note'), $deliveryOrderNumber)
        );
    }

    public function generateTerminalDeliveryOrderHistory(
        string $orderId,
        int $orderStatus,
        string $deliveryOrderNumber,
        string $shipmentGateway,
        string $shipmentMethod,
        string $parcelMachineStreet,
        string $parcelMachineLocation
    ): void {
        $comment = preg_replace("/,\s+,/", ',', sprintf(
            $this->language->get('order_terminal_delivery_note'),
            $shipmentGateway,
            $shipmentMethod,
            $parcelMachineStreet,
            $parcelMachineLocation,
            $deliveryOrderNumber
        ));
        $this->modelCheckoutOrder->addOrderHistory(
            $orderId,
            $orderStatus,
            $comment
        );
    }
}
