<?php

namespace Paysera\Delivery\Normalizer;

use Paysera\DeliveryApi\MerchantClient\Entity\ShipmentMethod;

class ShipmentMethodNormalizer
{
    const KEY_ID = 'id';
    const KEY_CODE = 'code';
    const KEY_DESCRIPTION = 'description';
    const KEY_RECEIVER_CODE = 'receiver_code';
    const KEY_ENABLED = 'enabled';

    /**
     * @param ShipmentMethod $shipmentMethod
     * @return array
     */
    public function mapFromEntity($shipmentMethod)
    {
        return [
            self::KEY_ID => $shipmentMethod->getId(),
            self::KEY_CODE => $shipmentMethod->getCode(),
            self::KEY_DESCRIPTION => $shipmentMethod->getDescription(),
            self::KEY_RECEIVER_CODE => $shipmentMethod->getReceiverCode(),
            self::KEY_ENABLED => $shipmentMethod->isEnabled(),
        ];
    }

    /**
     * @param ShipmentMethod[] $shipmentMethods
     * @return array
     */
    public function mapAssociativeArrayFromEntity($shipmentMethods)
    {
        $data = [];

        foreach ($shipmentMethods as $shipmentMethod) {
            $data[$shipmentMethod->getCode()] = $this->mapFromEntity($shipmentMethod);
        }

        return $data;
    }
}
