<?php

declare(strict_types=1);

namespace Paysera\Delivery\Model;

use Paysera\Delivery\Entity\ShipmentRequest;
use Paysera\Delivery\Normalizer\ShipmentRequestNormalizer;

class ShipmentRequestModel
{
    /**
     * ModelExtensionShippingPaysera - catalog/model/extension/shipping/paysera.php
     */
    private $shipmentRequestModel;

    /**
     * @var ShipmentRequestNormalizer
     */
    private $shipmentRequestNormalizer;

    public function __construct($shippingRequestModel, ShipmentRequestNormalizer $shipmentRequestNormalizer)
    {
        $this->shipmentRequestModel = $shippingRequestModel;
        $this->shipmentRequestNormalizer = $shipmentRequestNormalizer;
    }

    public function create(ShipmentRequest $shipmentRequest): void
    {
        $this->shipmentRequestModel->createShipmentRequest($shipmentRequest);
    }

    public function get(string $orderId): ?ShipmentRequest
    {
        $request = $this->shipmentRequestModel->getShippingRequest($orderId);

        if (count($request) === 0) {
            return null;
        }

        return $this->shipmentRequestNormalizer->mapToEntity($request);
    }

    public function update(ShipmentRequest $shipmentRequest): void
    {
        $this->shipmentRequestModel->updateShipmentRequest($shipmentRequest);
    }
}
