<?php

declare(strict_types=1);

if (is_file(DIR_SYSTEM . 'library/paysera/delivery/vendor/autoload.php')) {
    require_once DIR_SYSTEM . 'library/paysera/delivery/vendor/autoload.php';
}

use Paysera\Delivery\DatabaseTable;

class ModelExtensionShippingPaysera extends Model
{
    public function createTables(): void
    {
        $query = sprintf(
            <<<EOT
            CREATE TABLE IF NOT EXISTS `%s`
            (
                id                 INT(11) NOT NULL AUTO_INCREMENT,
                order_id           VARCHAR(255) NOT NULL,
                delivery_order_id  VARCHAR(255),
                shipping_method    VARCHAR(255) NOT NULL,
                status             VARCHAR(255) NOT NULL,
                gateway_terminal   VARCHAR(255),
                gateway_iso_code_2 VARCHAR(3),
                gateway_city       VARCHAR(255),
                gateway_zone_code  VARCHAR(255),
                PRIMARY KEY (`id`),
                UNIQUE KEY unique_order_id (order_id)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
            EOT,
            DatabaseTable::SHIPPING_REQUEST
        );

        $this->db->query($query);
    }

    public function deleteTables(): void
    {
        $query = sprintf(
            'DROP TABLE `%s`;',
            DatabaseTable::SHIPPING_REQUEST
        );
        $this->db->query($query);
    }
}
