<?php

namespace Paysera\Delivery\Service;

use Paysera\Delivery\Normalizer\ShipmentGatewayNormalizer;
use Paysera\Delivery\PayseraDeliverySettings;

class DeliveryGatewayResolver
{
    const PAYSERA_DELIVERY_GATEWAY_TYPES = [
        PayseraDeliverySettings::TYPE_COURIER => PayseraDeliverySettings::TYPE_COURIER,
        PayseraDeliverySettings::TERMINAL => PayseraDeliverySettings::TYPE_PARCEL_MACHINE,
    ];

    private $deliveryGatewayNormalizer;

    public function __construct(ShipmentGatewayNormalizer $deliveryGatewayNormalizer)
    {
        $this->deliveryGatewayNormalizer = $deliveryGatewayNormalizer;
    }

    /**
     * @param array $deliverGateways
     * @return array
     */
    public function resolveDeliveryGatewayTypes($deliverGateways)
    {
        $normalizedDeliveryGateway = [];

        foreach ($deliverGateways as $deliverGateway) {
            foreach (self::PAYSERA_DELIVERY_GATEWAY_TYPES as $deliveryGatewayPrefix => $deliveryGatewayType) {
                $title = $deliverGateway['description'];
                $title .= $this->isGatewayTypeCourier($deliveryGatewayType) ? ' Courier' : ' Terminal';

                $resolvedDeliveryGateway = array_merge(
                    $deliverGateway,
                    [
                        'code' => $deliverGateway['code'] . $deliveryGatewayPrefix,
                        'receiverType' => $deliveryGatewayType,
                        'description' => $title,
                    ]
                );

                $normalizedDeliveryGateway[] = $this->deliveryGatewayNormalizer->mapToEntity($resolvedDeliveryGateway);
            }
        }

        return $normalizedDeliveryGateway;
    }


    /**
     * @param string $deliveryGatewayType
     * @return bool
     */
    private function isGatewayTypeCourier($deliveryGatewayType)
    {
        return $deliveryGatewayType === PayseraDeliverySettings::TYPE_COURIER;
    }
}
