<?php

declare(strict_types=1);

namespace Paysera\Delivery\Repository;

use Paysera\Payment\Repository\Language;

class MessageRepository
{
    /**
     * @var Language system/library/language.php
     */
    protected $languageModel;

    /**
     * @param \Registry $registry
     */
    public function __construct($registry)
    {
        $registry->get('load')->language('extension/payment/paysera');

        $this->languageModel = $registry->get('language');
    }

    public function get(string $key): string
    {
        return $this->languageModel->get($key);
    }
}
