<?php

namespace Paysera\Delivery;

class PayseraDeliverySettings
{
    const SETTINGS_NAME = 'shipping_paysera';

    const STATUS = 'shipping_paysera_status';
    const TEST_MODE = 'shipping_paysera_test';
    const DELIVERY_GATEWAY = 'shipping_paysera_delivery_gateway';
    const PROJECT_ID  = 'shipping_paysera_project_id';
    const PROJECT_HASH  = 'shipping_paysera_project_hash';
    const PROJECT_PASSWORD  = 'shipping_paysera_project_password';
    const ORDER_STATUS  = 'shipping_paysera_order_status';

    const TITLE = 'title';
    const DESCRIPTION = 'description';
    const MAXIMUM_WEIGHT = 'maximum_weight';
    const MINIMUM_WEIGHT = 'minimum_weight';
    const FEE = 'fee';
    const SENDER_TYPE = 'sender_type';
    const RECEIVER_TYPE = 'receiver_type';
    const FREE_DELIVERY_THRESHOLD = 'free_delivery_threshold';
    const SORT_ORDER = 'sort_order';
    const SHIPMENT_GATEWAY = 'shipment_gateway';
    const GEO_ZONE = 'geo_zone';

    const DEFAULT_MAXIMUM_WEIGHT = 10;
    const DEFAULT_MINIMUM_WEIGHT = 0;
    const DEFAULT_FEE = 0;
    const DEFAULT_FREE_DELIVERY_THRESHOLD = 0;
    const DEFAULT_SENDER_TYPE = self::TYPE_COURIER;

    const LANGUAGE_ABOUT = 'extension/shipping/paysera/about';
    const LANGUAGE_NO_PLUGIN = 'extension/shipping/paysera/no_payment_plugin';
    const LANGUAGE_SETTINGS = 'extension/shipping/paysera';
    const LANGUAGE_DELIVERY_GATEWAY = 'extension/shipping/paysera/delivery_gateway';

    const SHIPPING_METHOD_PREFIX = 'paysera';

    const WEIGHT_CLASS_ID = 2;
    const LENGTH_CLASS_ID = 2;

    const TYPE_COURIER = 'courier';
    const TYPE_PARCEL_MACHINE = 'parcel-machine';
    const AVAILABLE_TYPES = [
        self::TYPE_COURIER => self::LANGUAGE_TYPE_COURIER_KEY,
        self::TYPE_PARCEL_MACHINE => self::LANGUAGE_TYPE_PARCEL_LOCKER_KEY,
    ];

    const TERMINAL = 'terminal';

    const LANGUAGE_TYPE_COURIER_KEY = 'text_courier';
    const LANGUAGE_TYPE_PARCEL_LOCKER_KEY = 'text_parcel_locker';
    const LANGUAGE_TERMINAL_KEY = 'text_terminal';
}
