<?php

namespace Paysera\Delivery;

use Paysera\Delivery\Entity\DeliveryGatewaySettings;

class PayseraDeliveryResolver
{
    /**
     * @param string $shippingMethod
     * @return string
     */
    public function resolveDeliveryGatewayCode($shippingMethod)
    {
        $deliveryGatewayArray = explode('_', $shippingMethod);

        return str_replace(
            [
                '_' . PayseraDeliverySettings::TYPE_COURIER,
                '_' . PayseraDeliverySettings::TERMINAL,
                PayseraDeliverySettings::SHIPPING_METHOD_PREFIX . '.',
            ],
            '',
            current($deliveryGatewayArray)
        );
    }

    /**
     * @param string $shippingMethod
     * @return int
     */
    public function resolveDeliveryGatewayIndex($shippingMethod)
    {
        $deliveryGatewayArray = explode('_', $shippingMethod);

        return end($deliveryGatewayArray);
    }

    /**
     * @param DeliveryGatewaySettings $deliveryGatewaySettings
     * @return string
     */
    public function resolveShippingMethodCode($deliveryGatewaySettings)
    {
        return $deliveryGatewaySettings->getSenderType() . '2' . $deliveryGatewaySettings->getReceiverType();
    }
}
