<?php

declare(strict_types=1);

namespace Paysera\Delivery\Normalizer;

use Paysera\Delivery\Entity\Order;

class OrderNormalizer
{
    public function mapToEntity(array $order): Order
    {
        return new Order(
            $order['order_id'],
            $order['payment_firstname'],
            $order['payment_lastname'],
            $order['email'],
            $order['telephone'],
            $order['shipping_iso_code_2'],
            $order['shipping_zone_code'],
            $order['shipping_city'],
            $order['shipping_address_1'],
            $order['shipping_postcode']
        );
    }
}
