<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class Order
{
    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $paymentFirstName;

    /**
     * @var string
     */
    private $paymentLastName;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $telephone;

    /**
     * @var string
     */
    private $shippingIsoCode2;

    /**
     * @var string
     */
    private $shippingZoneCode;

    /**
     * @var string
     */
    private $shippingCity;

    /**
     * @var string
     */
    private $shippingAddress1;

    /**
     * @var string
     */
    private $shippingPostcode;

    public function __construct(
        string $id,
        string $paymentFirstName,
        string $paymentLastName,
        string $email,
        string $telephone,
        string $shippingIsoCode2,
        string $shippingZoneCode,
        string $shippingCity,
        string $shippingAddress1,
        string $shippingPostcode
    ) {
        $this->id = $id;
        $this->paymentFirstName = $paymentFirstName;
        $this->paymentLastName = $paymentLastName;
        $this->email = $email;
        $this->telephone = $telephone;
        $this->shippingIsoCode2 = $shippingIsoCode2;
        $this->shippingZoneCode = $shippingZoneCode;
        $this->shippingCity = $shippingCity;
        $this->shippingAddress1 = $shippingAddress1;
        $this->shippingPostcode = $shippingPostcode;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getPaymentFirstName(): string
    {
        return $this->paymentFirstName;
    }

    public function getPaymentLastName(): string
    {
        return $this->paymentLastName;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function getShippingIsoCode2(): string
    {
        return $this->shippingIsoCode2;
    }

    public function getShippingZoneCode(): string
    {
        return $this->shippingZoneCode;
    }

    public function getShippingCity(): string
    {
        return $this->shippingCity;
    }

    public function getShippingAddress1(): string
    {
        return $this->shippingAddress1;
    }

    public function getShippingPostcode(): string
    {
        return $this->shippingPostcode;
    }
}
