$(document).ready(function() {
    let text_checkout_payment_method = $('#collapse-payment-method').parent().find('.panel-heading .panel-title').html();
    let text_checkout_confirm = $('#collapse-checkout-confirm').parent().find('.panel-heading .panel-title').html();
    let select_country = $('#input-gateway-delivery-country');
    let select_city = $('#input-gateway-delivery-city');
    let select_terminal = $('#input-gateway-delivery-terminal');
    let btn_shipping_method = $('#button-shipping-method');
    let route = 'extension/shipping/paysera/';
    let url = 'index.php';
    let default_index = 'default';

    select_country.select2();
    select_city.select2();
    select_terminal.select2();

    $('input[name="shipping_method"]').on("change", function(el) {
        $('#collapse-payment-method').parent().find('.panel-heading .panel-title').html(text_checkout_payment_method);
        $('#collapse-checkout-confirm').parent().find('.panel-heading .panel-title').html(text_checkout_confirm);
        $.ajax({
            url: `${url}?route=${route}onDeliveryMethodChange`,
            method: 'POST'
        });
        let delivery_gateway_code = $(this).val();
        let delivery_gateway_content = $('.paysera-delivery-gateway-content');
        let delivery_gateway_warning_content = $('.paysera-delivery-gateway-warning');

        if (delivery_gateway_code.indexOf('paysera') > -1) {
            let panel_shipping_method = $('#collapse-shipping-method');
            let before_textarea = panel_shipping_method.find('textarea').parent().prev().prev();

            before_textarea.after(delivery_gateway_content);
            before_textarea.after(delivery_gateway_warning_content);
            btn_shipping_method.prop('disabled', true);

            delivery_gateway_code = delivery_gateway_code.replace('paysera.', '');

            $.ajax({
                url,
                data: {
                    route: route + 'validate',
                    delivery_gateway_code
                }
            })
            .done(function (response) {
                delivery_gateway_content.addClass('hidden');
                delivery_gateway_warning_content.addClass('hidden');
                btn_shipping_method.prop('disabled', false);

                if (response.error) {
                    delivery_gateway_warning_content.removeClass('hidden');
                    delivery_gateway_warning_content.html(response.error);
                    delivery_gateway_content.addClass('hidden');
                    btn_shipping_method.prop('disabled', true);
                }

                if (response.has_delivery_terminal === 1) {
                    if (!response.error) {
                        btn_shipping_method.prop('disabled', true);
                        $.ajax({
                            url,
                            data: {
                                route: route + 'getCountryByGatewayCode',
                                delivery_gateway_code
                            }
                        }).done(function (response) {
                            if (response.redirect) {
                                window.location.href = response.redirect
                            }

                            delivery_gateway_content.html(response);
                        })

                        if (!delivery_gateway_content.find('#delivery_country_id').val()) {
                            select_country.val(default_index).trigger('change');
                        } else {
                            select_country.val(delivery_gateway_content.find('#delivery_country_id').val()).trigger('change');
                        }
                        select_city.parent().parent().addClass('hidden');
                        select_terminal.parent().parent().addClass('hidden');

                        delivery_gateway_warning_content.addClass('hidden');
                        delivery_gateway_content.removeClass('hidden');
                    }
                }
            });
        } else {
            delivery_gateway_content.addClass('hidden');
            delivery_gateway_warning_content.addClass('hidden');
            btn_shipping_method.prop('disabled', false);
        }
    });
});
