<?php

declare(strict_types=1);

namespace Paysera\Magento2Paysera\Observer;

use Magento\Framework\DataObject;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Payment\Model\InfoInterface;
use Magento\Payment\Observer\AbstractDataAssignObserver;
use Magento\Quote\Api\Data\PaymentInterface;
use Paysera\Magento2Paysera\Controller\Index\Index;
use Paysera\Magento2Paysera\Helper\Data;

class DataAssignObserver extends AbstractDataAssignObserver
{
    private const PAYSERA_PAYMENT_METHOD = 'paysera_payment_method';

    protected $helper;

    public function __construct(Data $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @param Observer $observer
     * @throws LocalizedException
     */
    public function execute(Observer $observer)
    {
        $data = $this->readDataArgument($observer);

        $additionalData = $data->getData(PaymentInterface::KEY_ADDITIONAL_DATA);

        if (!is_array($additionalData)) {
            return;
        }

        $paymentMethod = $this->readMethodArgument($observer);

        $payment = $observer->getPaymentModel();
        if (!$payment instanceof InfoInterface) {
            $payment = $paymentMethod->getInfoInstance();
        }

        if (!$payment instanceof InfoInterface) {
            throw new LocalizedException(__('Payment model does not provided.'));
        }

        $this->helper->setSessionData(
            Index::PAYSERA_TYPE,
            (new DataObject($additionalData))->getData(self::PAYSERA_PAYMENT_METHOD)
        );
    }
}
