<?php

namespace Paysera\Magento2Paysera\Model\Adminhtml\Source;

use Paysera\Magento2Paysera\Model\BuildHtmlCode;

class PayseraCountries
{
    /**
     * @param array $countries
     *
     * @return array
     */
    public function getCountriesList($countries)
    {
        $countriesList = [];

        foreach ($countries as $countryCode => $country) {
            if ($countryCode === '') {
                continue;
            }
 
            $countriesList[] = [
                'value' => $countryCode,
                'label' => $country,
            ];
        }

        return $countriesList;
    }

    /**
     * @return array<string, string>
     */
    public function getAllCountries()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        /** @var \Magento\Directory\Model\ResourceModel\Country\CollectionFactory $countryCollectionFactory */
        $countryCollectionFactory = $objectManager->get(\Magento\Directory\Model\ResourceModel\Country\CollectionFactory::class);

        /** @var \Magento\Directory\Model\ResourceModel\Country\Collection $countryCollection */
        $countryCollection = $countryCollectionFactory->create();

        $countryCollection = $countryCollection->toOptionArray();

        return array_column($countryCollection, 'label', 'value');
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $countriesList = $this->getAllCountries();

        $countriesList = $this->getCountriesList($countriesList);

        $otherExists = array_search(BuildHtmlCode::CODE_OTHER, array_column($countriesList, 'value')) !== false;

        if ($otherExists === false) {
            $countriesList[] = [
                'value' => BuildHtmlCode::CODE_OTHER,
                'label' => 'Other',
            ];
        }

        return $countriesList;
    }
}
