<?php

declare(strict_types=1);

namespace Paysera\Magento2Paysera\Helper;

use Evp\Component\Money\Money;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Locale\Resolver;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    private const PAYSERA_PAYMENT = 'payment/paysera';

    protected $pageFactory;
    protected $scopeConfig;
    protected $checkoutSession;
    protected $storeManager;
    protected $locale;
    protected $url;

    public function __construct(
        Context $context,
        PageFactory $pageFactory,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        Session $session,
        Resolver $locale,
        UrlInterface $url
    ) {
        parent::__construct($context);

        $this->pageFactory = $pageFactory;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->checkoutSession = $session;
        $this->locale = $locale;
        $this->url = $url;
    }

    public function getTotalAmount(): int
    {
        $quote = $this->checkoutSession->getQuote();

        return Money::create($quote->getSubtotalWithDiscount(), $quote->getQuoteCurrencyCode())
            ->getAmountInCents()
        ;
    }

    public function getOrderCurrencyCode(): string
    {
        return $this->checkoutSession->getQuote()->getQuoteCurrencyCode();
    }

    public function getOrderCountryCode(): string
    {
        return strtolower($this->checkoutSession->getQuote()->getShippingAddress()->getCountryId() ?? '');
    }

    public function getStoreLanguageCode(): string
    {
        return strstr($this->locale->getLocale(), '_', true);
    }

    /**
     * @param string $group
     * @param string|null $name
     * @return mixed
     */
    public function getPluginConfig(string $group, ?string $name = null)
    {
        $pluginConfig = $this->scopeConfig->getValue(self::PAYSERA_PAYMENT, ScopeInterface::SCOPE_STORE);

        if ($name === null) {
            return $pluginConfig[$group];
        }

        return $pluginConfig[$group][$name];
    }

    /**
     * @return string
     * @throws NoSuchEntityException
     */
    public function getPageBaseUrl(): string
    {
        return $this->storeManager->getStore()->getBaseUrl();
    }

    /**
     * @return string
     */
    public function getCartUrl(): string
    {
        return $this->url->getUrl('checkout/cart', ['_secure' => true]);
    }

    /**
     * @param string $key
     * @param mixed $value
     */
    public function setSessionData(string $key, $value): void
    {
        //TODO check is it works
        $this->checkoutSession->setData($key, $value);
    }

    /**
     * @param string $key
     * @return mixed
     */
    public function getSessionData(string $key)
    {
        return $this->checkoutSession->getData($key, false);
    }

    public function getRequestData(): array
    {
        switch ($_SERVER['REQUEST_METHOD']) {
            case 'GET':
                return filter_input_array(INPUT_GET);
            default:
                return filter_input_array(INPUT_POST);
        }
    }
}
