<?php

namespace Paysera\Magento2Paysera\Controller\Index;

use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\Action\Context;
use Magento\Sales\Model\Order;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Checkout\Model\Session;
use org\bovigo\vfs\UnlinkTestCase;
use Paysera\Magento2Paysera\Helper\Data;
use Magento\Framework\Controller\Result\JsonFactory;
use WebToPay;

class Index extends \Magento\Framework\App\Action\Action
{
    const PAYSERA_PLUGIN_VERSION = '3.3.1';
    const PAYSERA_PAYMENT = 'payment/paysera';
    const PAYSERA_EXTRA_SETTINGS = 'paysera_extra';
    const PAYSERA_STATUS = 'paysera_order_status';
    const ORDER_STATUS = 'pending_payment_order_status';
    const SUCCESS_ADDRESS = 'checkout/onepage/success?paysera';
    const CALLBACK_ADDRESS = 'paysera/index/callback';
    const CANCEL_ADDRESS = 'paysera/index/cancelorder';

    const PAYSERA_TYPE = 'paysera_payment_type';
    const REDIRECT = 'pageRedirectUrl';

    const DEFAULT_LANG = 'ENG';

    const LOCALE_CODE = 'general/locale/code';

    protected $_pageFactory;
    protected $_checkoutSession;
    protected $_scopeConfig;
    protected $_storeManager;
    protected $_helper;

    protected $payseraLangs;

    protected $jsonResultFactory;
    /**
     * @var ProductMetadataInterface
     */
    protected $productMetadata;

    public function __construct(
        Context $context,
        PageFactory $pageFactory,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        Session $checkoutSession,
        Data $helper,
        JsonFactory $jsonResultFactory,
        ProductMetadataInterface $productMetadata
    ) {
        $this->jsonResultFactory = $jsonResultFactory;
        $this->productMetadata = $productMetadata;
        $this->_pageFactory = $pageFactory;
        $this->_scopeConfig = $scopeConfig;
        $this->_storeManager = $storeManager;
        $this->_checkoutSession = $checkoutSession;
        $this->_helper = $helper;

        $this->payseraLangs = [
            'lt' => 'LIT',
            'lv' => 'LAV',
            'et' => 'EST',
            'ru' => 'RUS',
            'de' => 'GER',
            'pl' => 'POL',
            'en' => 'ENG',
        ];

        return parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     *
     * @throws \WebToPayException|\Exception
     */
    public function execute()
    {
        $order = $this->_checkoutSession->getLastRealOrder();

        $paysera_config = $this->_scopeConfig->getValue(
            self::PAYSERA_PAYMENT,
            ScopeInterface::SCOPE_STORE
        );

        $order->setStatus(
            $paysera_config[self::PAYSERA_STATUS][self::ORDER_STATUS]
        )->save();

        $payment = $this->getDataFromSession(self::PAYSERA_TYPE);

        return $this->jsonResultFactory->create()->setData(['url' => $this->getPayseraPaymentUrl($payment)]);
    }

    /**
     * @param string $name
     *
     * @return string
     */
    protected function getDataFromSession($name)
    {
        return $this->_helper->getSessionData($name);
    }

    /**
     * @return string
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getBasePage()
    {
        return $this->_helper->getPageBaseUrl();
    }

    /**
     * @param string $payment
     * @return string
     *
     * @throws \WebToPayException|\Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getPayseraPaymentUrl($payment)
    {
        $order = $this->_checkoutSession->getLastRealOrder();

        $paysera_config = $this->_scopeConfig->getValue(
            self::PAYSERA_PAYMENT,
            ScopeInterface::SCOPE_STORE
        );

        $selectedLanguage = $this->_scopeConfig->getValue(
            self::LOCALE_CODE,
            ScopeInterface::SCOPE_STORE
        );

        $selectedLanguageCode = substr($selectedLanguage ?? '', 0, 2);
        if (array_key_exists($selectedLanguageCode, $this->payseraLangs)) {
            $lang = $this->payseraLangs[$selectedLanguageCode];
        } else {
            $lang = self::DEFAULT_LANG;
        }

        $buildParameters = [
            'projectid' => $paysera_config['projectid'],
            'sign_password' => $paysera_config['sign_password'],

            'orderid' => $order->getIncrementId(),
            'amount' => $order->getGrandTotal() * 100,
            'currency' => $order->getOrderCurrencyCode(),

            'accepturl' => $this->getBasePage() . self::SUCCESS_ADDRESS,
            'callbackurl' => $this->getBasePage() . self::CALLBACK_ADDRESS,
            'cancelurl' => $this->getOrderCancellationUrl($order),

            'p_firstname' => $order->getBillingAddress()->getFirstname(),
            'p_lastname' => $order->getBillingAddress()->getLastname(),
            'p_email' => $order->getBillingAddress()->getEmail(),
            'p_street' => $order->getBillingAddress()->getStreet()[0],
            'p_city' => $order->getBillingAddress()->getCity(),
            'p_state' => substr($order->getBillingAddress()->getRegion() ?? '', 0, 20),
            'p_zip' => $order->getBillingAddress()->getPostcode(),
            'p_countrycode' => $order->getBillingAddress()->getCountryId(),

            'payment' => $payment,
            'lang' => $lang,

            'test' => $paysera_config['test'],
            'buyer_consent' => $paysera_config[self::PAYSERA_EXTRA_SETTINGS]['buyer_consent'],

            'plugin_name' => 'Magento',
            'plugin_version' => self::PAYSERA_PLUGIN_VERSION,
            'php_version' => phpversion(),
            'cms_version' => $this->productMetadata->getVersion(),
        ];

        $request = WebToPay::buildRequest($buildParameters);

        return preg_replace(
            '/[\r\n]+/is',
            '',
            WebToPay::PAY_URL . '?' . http_build_query($request)
        );
    }

    private function getOrderCancellationUrl(Order $order): string
    {
        $query = http_build_query(
            [
                'data' => base64_encode(
                    http_build_query(
                        ['order_id' => $order->getId()]
                    )
                ),
            ]
        );

        return $this->getBasePage() . self::CANCEL_ADDRESS . '?' . $query;
    }
}
