<?php

declare(strict_types=1);

namespace Paysera\Magento2Paysera\Block\Adminhtml\Form\Field;

use Magento\Config\Block\System\Config\Form\Field\Select\Allowspecific;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Data\Form\Element\Select;
use Magento\Framework\Escaper;
use Magento\Framework\View\Helper\SecureHtmlRenderer;
use Paysera\Magento2Paysera\Model\BuildHtmlCode;

class PayseraAllowspecific extends Allowspecific
{
    private ?SecureHtmlRenderer $secureRenderer;

    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param array $data
     * @param SecureHtmlRenderer|null $secureRenderer
     */
    public function __construct(
        Factory $factoryElement,
        CollectionFactory $factoryCollection,
        Escaper $escaper,
        array $data = [],
        ?SecureHtmlRenderer $secureRenderer = null
    ) {
        $secureRenderer = $secureRenderer ?? ObjectManager::getInstance()->get(SecureHtmlRenderer::class);
        parent::__construct($factoryElement, $factoryCollection, $escaper, $data, $secureRenderer);
        $this->secureRenderer = $secureRenderer;
    }

    public function getAfterElementHtml(): string
    {
        $elementId = $this->getHtmlId();
        $countryListId = $this->_getSpecificCountryElementId();

        $htmlBuilder = new BuildHtmlCode;
        $elementJavaScript = $htmlBuilder->renderView(
            __DIR__.'/View/PayseraAllowspecific.html',
            [
                'elementId' => $elementId,
                'useDefaultElementId' => $elementId.'_inherit',
                'countryListId' => $countryListId,
                'useDefaultCountryListId' => $countryListId.'_inherit',
            ]
        );

        return $elementJavaScript.Select::getAfterElementHtml();
    }
}
