<?php

declare(strict_types=1);

namespace Paysera\Magento2Paysera\Controller\Index;

use Magento\Framework\App\ActionInterface;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Sales\Model\Order;
use Paysera\Magento2Paysera\Helper\Data as DataHelper;
use Paysera\Magento2Paysera\Service\OrderService;
use Throwable;

class CancelOrder implements ActionInterface
{
    protected Raw $rawResult;
    protected DataHelper $dataHelper;
    protected RedirectFactory $redirectFactory;
    protected OrderService $orderService;

    public function __construct(
        Raw $rawResult,
        RedirectFactory $redirectFactory,
        DataHelper $dataHelper,
        OrderService $orderService
    ) {
        $this->rawResult = $rawResult;
        $this->dataHelper = $dataHelper;
        $this->redirectFactory = $redirectFactory;
        $this->orderService = $orderService;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $requestData = $this->getRequestData();
        $baseUrl = $this->dataHelper->getPageBaseUrl();
        $checkoutUrl = $this->dataHelper->getCartUrl();

        try {
            $order = $this->getOrder($requestData);

            if ($order === null) {
                return $this->redirect($baseUrl);
            }

            $this->orderService->cancelOrder($order);
            $this->orderService->restoreCart($order);
        } catch (Throwable $e) {
            return $this->rawResult->setContents(get_class($e) . ': ' . $e->getMessage());
        }

        return $this->redirect($requestData['redirect'] ?? $checkoutUrl);
    }

    private function getOrder(?array $requestData): ?Order
    {
        return !empty($requestData['order_id'])
            ? $this->orderService->getOrder((int)$requestData['order_id'])
            : null;
    }

    private function getRequestData(): ?array
    {
        $requestData = $this->dataHelper->getRequestData();

        if (!isset($requestData['data'])) {
            return null;
        }

        parse_str(base64_decode($requestData['data']), $requestData);

        return $requestData;
    }

    private function redirect(string $url): Redirect
    {
        return $this->redirectFactory
            ->create()
            ->setUrl($url)
        ;
    }
}
