/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author    Paysera <plugins@paysera.com>
 *  @copyright 2018 Paysera
 *  @license   GPL version 3 or later - http://www.gnu.org/licenses/gpl-3.0.html
 *  International Registered Trademark & Property of Paysera
 */

jQuery(document).ready(function ($) {
    let fieldsAction = {
        required: function() {
            let enableBtn = true;
            $('.required').each(function() {
                let value = $(this).val();
                if (value === '') {
                    $(this).css("background-color", "#FFCECE");
                    enableBtn = false;
                    $('.button-apply').attr('disabled','disabled');
                    $('.button-save').attr('disabled','disabled');
                }
                if (enableBtn) {
                    $(this).css("background-color", "transparent");
                    $('.button-apply').removeAttr('disabled');
                    $('.button-save').removeAttr('disabled');
                }
            });
        }
    };

    fieldsAction.required();
    $('input').on('input', function() {
        fieldsAction.required();
    });

    let navTab = $('.paysera-tabs .nav-tab-active');
    $('.paysera-tabs .tab-content').hide();
    $(navTab.data('target')).show();

    $('.paysera-tabs nav .tab-title').on('click', function() {
        let selectedObj = $(this);
        selectedObj.addClass('nav-tab-active').siblings().removeClass('nav-tab-active');
        $(selectedObj.data('target')).show().siblings().hide();
    });

    $("a.tab-title").on('click', function(event) {
        event.preventDefault();
    });
});

