<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author    Paysera <plugins@paysera.com>
 *  @copyright 2018 Paysera
 *  @license   GPL version 3 or later - http://www.gnu.org/licenses/gpl-3.0.html
 *  International Registered Trademark & Property of Paysera
 */

defined('_JEXEC') or die('Restricted access');
?>

<div id="formSettingsPanel" class="panel">
	<div class="paysera-tabs">
        <?php if (@$this->element->payment_params->adminForm) { ?>
        <nav>
            <?php foreach (@$this->element->payment_params->adminForm as $key => $tab) { ?>
            <a class="tab-title <?= ($key === 0)?' nav-tab-active':''; ?>"
               href="#"
               id="<?= $tab['id']; ?>"
               data-target="#paysera-tabs-<?= $tab['id']; ?>">
                <?= $tab['title']; ?>
            </a>
            <?php } ?>
        </nav>
        <div class="content">
            <?php foreach (@$this->element->payment_params->adminForm as $key => $tab) { ?>
            <div class="tab-content" id="paysera-tabs-<?= $tab['id']; ?>">
                <?php
                $values = array();
                foreach ($tab['content']['settings'] as $key => $setting) {
                    $values[$key] = $setting;
                }
                foreach ($tab['content']['fields_form'] as $field_form) {
                    foreach ($field_form as $form) {
                        foreach ($form as $key => $fields) {
                            if ($key=='input') {
                                foreach ($fields as $field) { ?>
                                    <div class="paysera-keys">
                                        <div class="paysera-label"><?php echo $field['label']; ?></div>
                                        <div class="paysera-param"><?php
                                            $data = 'data[payment][payment_params]'.'['.$field['name'].']';
                                            $value = $values[$field['name']];
                                            $required = '';
                                            if ($field['required']) {
                                                $required = 'required';
                                            }

                                            switch ($field['type']) {
                                                case 'text':
                                                case 'number':
                                                    echo '<input type="'.$field['type'].'"'
                                                        .' name="'.$data.'"'
                                                        .' value="'.$value.'"'
                                                        .' class="'.$required.'" />';
                                                    break;
                                                case 'select':
                                                    $multiple = '';
                                                    $valueString = $value;

                                                    if ($field['multiple']) {
                                                        $multiple = 'multiple';
                                                        $data .= '[]';
                                                        $valueArray = $value;

                                                        if ($valueArray) {
                                                            $valueString = implode(',', $value);
                                                        } else {
                                                            $valueArray = array();
                                                        }
                                                    } else {
                                                        $valueArray = [$value];
                                                    }

                                                    echo '<select id="getThatField" '.$multiple
                                                        .' name="'.$data.'"'
                                                        .' value="'.$valueString.'"'
                                                        .' class="'.$required.'" >';

                                                    foreach ($field["options"]["query"] as $option) {
                                                        $id = $option[$field["options"]["id"]];
                                                        $name = $option[$field["options"]["name"]];

                                                        if (in_array($id, $valueArray)) {
                                                            $selected = ' selected';
                                                        } else {
                                                            $selected = '';
                                                        }

                                                        echo '<option'.$selected.' value="'.$id.'">'.$name.'</option>';
                                                    }

                                                    echo '</select>';
                                                    break;
                                                case 'switch':
                                                    echo JHTML::_('hikaselect.booleanlist', $data, '', $value);
                                                    break;
                                                case 'status':
                                                    echo $this->data['order_statuses']->display($data, $value);
                                                    break;
                                                default:
                                                    false;
                                                    break;
                                            } ?>
                                        </div>
                                    </div><?php
                                }
                            }
                        }
                    }
                } ?>
            </div><?php
            } ?>
        </div><?php
        } ?>
	</div>
</div>

