<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author    Paysera <plugins@paysera.com>
 *  @copyright 2018 Paysera
 *  @license   GPL version 3 or later - http://www.gnu.org/licenses/gpl-3.0.html
 *  International Registered Trademark & Property of Paysera
 */

defined('_JEXEC') or die('Restricted access');

if (!class_exists('WebToPay')) {
    require_once 'lib/WebToPay/WebToPay.php';
}

class plgHikashoppaymentPaysera extends hikashopPaymentPlugin
{
    /**
     * Path to backend style file
     */
    const BACKEND_STYLE = 'plugins/hikashoppayment/paysera/assets/css/backoffice.css';

    /**
     * Path to backend script file
     */
    const BACKEND_SCRIPT = 'plugins/hikashoppayment/paysera/assets/js/backoffice.js';

    /**
     * Path to frontend style file
     */
    const FRONTEND_STYLE = 'plugins/hikashoppayment/paysera/assets/css/payment-methods.css';

    /**
     * Path to frontend script file
     */
    const FRONTEND_SCRIPT = 'plugins/hikashoppayment/paysera/assets/js/payment-methods.js';

    /**
     * Path to one folder back
     */
    const BACK = '../';

    /**
     * ID of TAB 1
     */
    const TAB_1_ID = 'general_setting';

    /**
     * ID of TAB 2
     */
    const TAB_2_ID = 'extra_setting';

    /**
     * ID of TAB 3
     */
    const TAB_3_ID = 'order_status';

    /**
     * ID of TAB 4
     */
    const TAB_4_ID = 'addition_setting';

    /**
     * Name of TAB 1
     */
    const TAB_1_TAG = 'MAIN_SETTINGS';

    /**
     * Name of TAB 2
     */
    const TAB_2_TAG = 'EXTRA_SETTINGS';

    /**
     * Name of TAB 3
     */
    const TAB_3_TAG = 'ORDER_STATUS';

    /**
     * Name of TAB 4
     */
    const TAB_4_TAG = 'ADDITION_SETTINGS';

    /**
     * Payment method cookie name
     */
    const PAYMENT_COOKIE = 'paysera_payment_method';

    /**
     * Paysera selected cookie name
     */
    const PAYSERA_SELECTION = 'paysera_selected';

    /**
     * Default value of string
     */
    const DEFAULT_TEXT = '';

    /**
     * Default value of boolean
     */
    const DEFAULT_BOOL = false;

    /**
     * Default value of int | bool
     */
    const DEFAULT_INT = 0;

    var $multiple = true;
    var $name = 'paysera';

    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);

        $lang = JFactory::getLanguage();
        $lang->load('plg_hikashop_paysera');
    }

    function onPaymentConfiguration(&$element)
    {
        parent::onPaymentConfiguration($element);

        if (!class_exists('PayseraAdminForm')) {
            require_once 'classes/PayseraAdminForm.php';
        }

        $document = JFactory::getDocument();
        $document->addStyleSheet($this::BACK . $this::BACKEND_STYLE);
        $document->addScript($this::BACK . $this::BACKEND_SCRIPT);

        $lang          = JFactory::getLanguage();
        $currentLang   = $lang->getTag();
        $explodeLang   = explode('-', $currentLang);
        $langISO       = $explodeLang[0];

        $formObj = PayseraAdminForm::create()
            ->setProjectID(@$element->payment_params->PAYSERA_GENERAL_PROJECT_ID)
            ->setSign(@$element->payment_params->PAYSERA_GENERAL_SIGN_PASS)
            ->setTest(@$element->payment_params->PAYSERA_GENERAL_TEST_MODE)
            ->setLang($langISO)
            ->setPaymentList(@$element->payment_params->PAYSERA_EXTRA_LIST_OF_PAYMENTS)
            ->setGrid(@$element->payment_params->PAYSERA_EXTRA_GRIDVIEW)
            ->setBuyerConsent(@$element->payment_params->PAYSERA_EXTRA_BUYER_CONSENT)
            ->setCountriesSelected(@$element->payment_params->PAYSERA_EXTRA_SPECIFIC_COUNTRIES)
            ->setDefaultCountry(@$element->payment_params->PAYSERA_EXTRA_DEFAULT_COUNTRY)
            ->setOrderNew(@$element->payment_params->PAYSERA_ORDER_STATUS_NEW)
            ->setOrderPaid(@$element->payment_params->PAYSERA_ORDER_STATUS_PAID)
            ->setOrderPending(@$element->payment_params->PAYSERA_ORDER_STATUS_PENDING)
            ->setQuality(@$element->payment_params->PAYSERA_ADDITIONS_QUALITY_SIGN)
            ->setOwnership(@$element->payment_params->PAYSERA_ADDITIONS_OWNERSHIP)
            ->setOwnershipCode(@$element->payment_params->PAYSERA_ADDITIONS_OWNERSHIP_CODE)
        ;

        $generalSettings = $formObj->getGeneralSettingTemplate();
        $extraSettings = $formObj->getExtraSettingTemplate();
        $statusSettings = $formObj->getStatusSettingTemplate();
//        $additionSettings = $formObj->getAdditionsSettingTemplate();

        $formObj->addTab($this::TAB_1_ID, $this::TAB_1_TAG, $generalSettings);

        $projectID = $formObj->getProjectID();
        if (!empty($projectID)) {
            $formObj->addTab($this::TAB_2_ID, $this::TAB_2_TAG, $extraSettings);
            $formObj->addTab($this::TAB_3_ID, $this::TAB_3_TAG, $statusSettings);
//            $formObj->addTab($this::TAB_4_ID, $this::TAB_4_TAG, $additionSettings);
        }

        @$element->payment_params->adminForm = $formObj->getTabs();
    }

    function getPaymentDefaultValues(&$element)
    {
        $element->payment_name        = JText::_('PAYSERA_CHECKOUT_TITLE');
        $element->payment_description = JText::_('PAYSERA_CHECKOUT_DESCRIPTION');
        $element->payment_images      = 'paysera';
    }

    function onPaymentDisplay(&$order, &$methods, &$usable_methods) {
        if (!empty($methods)) {
            foreach ($methods as $method) {
                if ($method->payment_type != 'paysera' || !$method->enabled) {
                    continue;
                }

                $paymentZone = $method->payment_zone_namekey;
                if (!empty($paymentZone)) {
                    $zoneClass = hikashop::get('class.zone');
                    $zones     = $zoneClass->getOrderZones($order);
                    if (!in_array($method->payment_zone_namekey, $zones)) {
                        return true;
                    }
                }

                if (!class_exists('PayseraPaymentMethods')) {
                    require_once 'classes/PayseraPaymentMethods.php';
                }

                $null = null;
                $params = $method->payment_params;

                $projectID             = $params->PAYSERA_GENERAL_PROJECT_ID;
                $description           = $method->payment_description;
                $gridView              = (bool) $params->PAYSERA_EXTRA_GRIDVIEW;
                $buyerConsent          = (bool) $params->PAYSERA_EXTRA_BUYER_CONSENT;
                $displayPaymentMethods = (bool) $params->PAYSERA_EXTRA_LIST_OF_PAYMENTS;

                if (property_exists($params, 'PAYSERA_EXTRA_SPECIFIC_COUNTRIES')) {
                    $selectedCountries = $params->PAYSERA_EXTRA_SPECIFIC_COUNTRIES;
                } else {
                    $selectedCountries = '';
                }

                $lang          = JFactory::getLanguage();
                $currentLang   = $lang->getTag();
                $explodeLang   = explode('-', $currentLang);
                $langISO       = $explodeLang[0];
                $country       = $params->PAYSERA_EXTRA_DEFAULT_COUNTRY;

                $cartTotal     = (int)(round(@$order->total->prices[0]->price_value_with_tax,2)*100);
                $currencyClass = hikashop_get('class.currency');
                $curencies     = $currencyClass->getCurrencies(@$order->total->prices[0]->price_currency_id, $null);
                $resetCurrency = reset($curencies);
                $currency      = $resetCurrency->currency_code;

                $availableLang = array('lt', 'lv', 'ru', 'en', 'pl', 'bg', 'ee');

                $additionalInfo = PayseraPaymentMethods::create()
                    ->setProjectID($projectID)
                    ->setLang($langISO)
                    ->setBillingCountry($country)
                    ->setDisplayList($displayPaymentMethods)
                    ->setCountriesSelected($selectedCountries)
                    ->setGridView($gridView)
                    ->setBuyerConsent($buyerConsent)
                    ->setDescription($description)
                    ->setCartTotal($cartTotal)
                    ->setCartCurrency($currency)
                    ->setAvailableLang($availableLang)
                ;

                if ($displayPaymentMethods) {
                    $hide = $this::DEFAULT_BOOL;
                    $cookie = JFactory::getApplication()->input->cookie;
                    if ($selected = $cookie->get($this::PAYSERA_SELECTION)) {
                        $hide = $selected;
                    }

                    $paymentMethods = $additionalInfo->build(false);
                    $descriptionDiv = '<div id="paysera-desc">'.$method->payment_description .'</div>';
                    $methodDiv      = '<div id="paysera-methods" hidden>'.$paymentMethods.'</div>';

                    $jsDesc = 'jQuery(\'#paysera-desc\').hide()';
                    $jsMeth = 'jQuery(\'#paysera-methods\').show()';
                    $jsCode = 'var showMethod ='.$hide.';' .'if(showMethod) { '.$jsDesc.'; '.$jsMeth.'; }';
                    $script = '<script>' . $jsCode .'</script>';

                    $method->payment_description = $descriptionDiv . $methodDiv . $script;
                }

                $usable_methods[$method->ordering] = $method;

                $document = JFactory::getDocument();
                $document->addStyleSheet($this::FRONTEND_STYLE);
                $document->addScript($this::FRONTEND_SCRIPT);
            }
        }
    }

    function onAfterOrderConfirm(&$order, &$methods, $method_id)
    {
        parent::onAfterOrderConfirm($order,$methods,$method_id);

        $payment = $this::DEFAULT_TEXT;
        $cookie = JFactory::getApplication()->input->cookie;
        if ($paymentMethod = $cookie->get($this::PAYMENT_COOKIE)) {
            $payment = $paymentMethod;
        }

        $paymentData = $this->collectPaymentData($order, $payment);

        $orderID       = $order->order_id;
        $pendingStatus = $this->payment_params->PAYSERA_ORDER_STATUS_PENDING;
        $this->modifyOrder($orderID, $pendingStatus,true,true);

        WebToPay::redirectToPayment($paymentData, true);
    }

    /**
     * @param array $order
     * @param string $payment
     *
     * @return array|null
     */
    protected function collectPaymentData($order, $payment)
    {
        $projectID         = $this->payment_params->PAYSERA_GENERAL_PROJECT_ID;
        $projectPassword   = $this->payment_params->PAYSERA_GENERAL_SIGN_PASS;
        $testMode          = $this->payment_params->PAYSERA_GENERAL_TEST_MODE;
        $buyerConsent      = $this->payment_params->PAYSERA_EXTRA_BUYER_CONSENT;

        $cart              = $order->cart;
        $orderID           = $order->order_number;
        $totalAmount       = round($cart->full_total->prices[0]->price_value_with_tax, 2) * 100;
        $currency          = $this->currency->currency_code;

        $countryCode       = $cart->billing_address->address_country->zone_code_2;
        $paymentMethod     = $payment;
        $customerFirstname = $cart->billing_address->address_firstname;
        $customerLastname  = $cart->billing_address->address_lastname;
        $customerEmail     = $this->user->user_email;
        $billingAddress    = $cart->billing_address->address_street;
        $billingCity       = $cart->billing_address->address_city;
        $billingState      = $cart->billing_address->address_state->zone_name;
        $billingPostCode   = $cart->billing_address->address_post_code;
        $billingCountry    = $cart->billing_address->address_country->zone_code_2;

        $langObj           = JFactory::getLanguage();
        $currentLang       = $langObj->getTag();
        $explodeLang       = explode('-', $currentLang);
        $langISO           = $explodeLang[0];
        $lang              = $this->getPayseraLangCode($langISO);

        $notifyURL = HIKASHOP_LIVE
            .'index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment=paysera&tmpl=component&lang='
            .$this->locale
            .$this->url_itemid
            .'&orderID='
            .$order->order_id
        ;

        $acceptUrl   = $notifyURL.'&user_action=accept';
        $cancelUrl   = $notifyURL.'&user_action=cancel';
        $callbackUrl = $notifyURL.'&user_action=callback';

        $data = array(
            'projectid'     => $projectID,
            'sign_password' => $projectPassword,
            'orderid'       => $orderID,
            'amount'        => $totalAmount,
            'currency'      => $currency,
            'country'       => $countryCode,
            'accepturl'     => $acceptUrl,
            'cancelurl'     => $cancelUrl,
            'callbackurl'   => $callbackUrl,
            'test'          => (int) $testMode,
            'payment'       => $paymentMethod,
            'p_firstname'   => $customerFirstname,
            'p_lastname'    => $customerLastname,
            'p_email'       => $customerEmail,
            'p_street'      => $billingAddress,
            'p_city'        => $billingCity,
            'p_state'       => $billingState,
            'p_zip'         => $billingPostCode,
            'p_countrycode' => $billingCountry,
            'lang'          => $lang,
            'buyer_consent' => (int) $buyerConsent,
        );

        return $data;
    }

    /**
     * @param string $langISO
     *
     * @return string
     */
    protected function getPayseraLangCode($langISO)
    {
        switch ($langISO) {
            case 'lt':
                return 'LIT';
            case 'lv':
                return 'LAV';
            case 'ee':
                return 'EST';
            case 'ru':
                return 'RUS';
            case 'de':
                return 'GER';
            case 'pl':
                return 'POL';
            default:
                return 'ENG';
        }
    }

    function onPaymentNotification(&$statuses)
    {
        global $Itemid;
        $this->url_itemid = empty($Itemid) ? '' : '&Itemid=' . $Itemid;

        $method_id = hikaInput::get()->getInt('notif_id', 0);
        $this->pluginParams($method_id);
        $this->payment_params =& $this->plugin_params;

        $request = $_REQUEST;
        $idOrder = $request['orderID'];
        $order   = $this->getOrder($idOrder);

        switch ($request['user_action']) {
            case 'accept':
                $url = HIKASHOP_LIVE
                    .'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='
                    .$idOrder
                    .$this->url_itemid
                ;
                $orderOldStateId  = $order->order_status;
                $paidOrderStateId = $this->payment_params->PAYSERA_ORDER_STATUS_PAID;
                $newOrderStatus     = $this->payment_params->PAYSERA_ORDER_STATUS_NEW;
                if ($orderOldStateId !== $paidOrderStateId) {
                    $this->modifyOrder($idOrder, $newOrderStatus,true,true);
                }
                break;
            case 'cancel':
                $url = HIKASHOP_LIVE
                    .'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id='
                    .$idOrder
                    .$this->url_itemid
                ;
                break;
            default:
                $url = null;
                break;
        }

        if ($url) {
            $this->loadOrderData($order);
            $this->app->redirect($url);
        }

        $projectID            = $this->payment_params->PAYSERA_GENERAL_PROJECT_ID;
        $projectPassword      = $this->payment_params->PAYSERA_GENERAL_SIGN_PASS;
        $currencyClass        = hikashop::get('class.currency');

        try {
            $response = WebToPay::validateAndParseData($request, $projectID, $projectPassword);

            if ($response['status'] == 1) {
                $responseAmount   = (int) $response['payamount'];
                $responseCurrency = $response['paycurrency'];

                $orderAmount   = round($order->order_full_price, 2)*100;
                $curencies     = $currencyClass->getCurrencies($order->order_currency_id, $null);
                $currencyObj   = reset($curencies);
                $orderCurrency = $currencyObj->currency_code;

                if ($responseAmount != $orderAmount) {
                    exit(sprintf('Bad amount: %s', $responseAmount));
                }

                if ($responseCurrency != $orderCurrency) {
                    exit(sprintf('Bad currency: %s', $responseCurrency));
                }

                $orderOldStatus = $order->order_status;
                $paidStatus  = $this->payment_params->PAYSERA_ORDER_STATUS_PAID;
                if ($orderOldStatus !== $paidStatus) {
                    $this->modifyOrder($idOrder, $paidStatus,true,true);
                }

                exit('OK');
            }
        } catch (Exception $e) {
            exit($e->getMessage());
        }
    }
}
