/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author    Paysera <plugins@paysera.com>
 *  @copyright 2018 Paysera
 *  @license   GPL version 3 or later - http://www.gnu.org/licenses/gpl-3.0.html
 *  International Registered Trademark & Property of Paysera
 */

jQuery(document).ready(function($) {
    const PAYSERA_RADIO_TAG = '[data-hk-checkout*=\'"block":"payment","type":"paysera"\']';
    const PAYSERA_METHOD    = 'paysera_payment_method';
    const PAYSERA_SELECTED  = 'paysera_selected';

    let methodsField = {
        onSelect: function(tag) {
            if($(tag).is(':checked')) {
                this.setCookie(PAYSERA_SELECTED, true, 1);
            } else {
                this.setCookie(PAYSERA_SELECTED, false, 1);
            }
        },
        setCookie: function(cname, cvalue, exdays) {
            let d = new Date();
            d.setTime(d.getTime() + (exdays*24*60*60*1000));
            let expires = "expires="+ d.toUTCString();
            document.cookie = cname+"="+cvalue+";"+expires+";path=/";
        },
        getCookie: function(cname) {
            let name = cname + "=";
            let decodedCookie = decodeURIComponent(document.cookie);
            let ca = decodedCookie.split(';');
            for(let i = 0; i <ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        }
    };

    methodsField.onSelect(PAYSERA_RADIO_TAG);
    methodsField.setCookie(PAYSERA_METHOD, '', 1);

    $(document).on('change', '#paysera_country' ,function(){
        $('.payment-countries').hide('slow');
        $('#' + $('#paysera_country').val()).show('slow');
    });

    $(document).on('click', '[data-hk-checkout]' ,function(event){
        methodsField.onSelect(PAYSERA_RADIO_TAG);
    });

    $(document).on('change', 'input[name="payment[pay_type]"]' ,function(event){
        $('.payment').removeClass('activePayseraPayment');
        $(this).parent().parent().addClass('activePayseraPayment');
        methodsField.setCookie(PAYSERA_METHOD, event.target.value, 1);
    });
});
